(deftemplate block
	(slot name)
	(slot size (type INTEGER) (range 1 ?VARIABLE))
	(slot place (type SYMBOL) (allowed-symbols heap stack) (default ?DERIVE))
)

(deffacts blocks
	(block (name a) (size 10))
	(block (name b) (size 20))
	(block (name c) (size 30))
)

(defrule begin
	(initial-fact)
  =>
	(assert (stack 1))
)

(defrule stop
	?x <- (stack ?N)
	(not (block (place heap)))
  =>
	(retract ?x)
	(halt)
)

(defrule move_to_stack
	?x <- (stack ?N)
	?y <- (block (name ?B1) (size ?S1) (place heap))
	(not (and (block (name ?B2&~B1) (size ?S2) (place heap))
		  (test (> ?S2 ?S1))))
  =>
	(modify ?y (place stack))
	(retract ?x)
	(assert (stack (+ ?N 1)))
)
